﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="Artikel.aspx.cs" Inherits="ccPublisherWeb.Artikel" %>
<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<%@ Register Src="~/Controls/Pager.ascx" TagName="Pager" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/PageHeader.ascx" TagName="PageHeader" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/CadBoxDialogControl.ascx" TagName="CadBoxDialogControl" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head id="Head1" runat="server">
   <title>Artikel</title>

   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ArtikelGrid.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="Pager.css" runat="server" />
   
   <script language="javascript" type="text/javascript">
       var prevImageTimer = null;
       var dialogFirstRun = true;
       var viewerActive = false;
       var articledetaildialog;

       function changeGridView(gridMode)
       {
           pageLock();
           $("#<%# hdGridMode.ClientID %>").val(gridMode);
           setTimeout(function() { <%# Page.ClientScript.GetPostBackEventReference(hdPostbackGridMode, "") %> }, 0);
       }

       function prevImageTT(imageURL, width, height) {
           if(prevImageTimer != null) { try { clearTimeout(prevImageTimer); } catch(e) {} }

           prevImageTimer = setTimeout(function() {
               if(prevImageTimer != null) {
                   Tip(
                       String.format(
                           "<div style='background-image:url({0}); background-positon:center center; background-repeat:no-repeat; width:{1}px;height:{2}px' class='ThumbnailCadDatenTooltip'></div>",
                           imageURL,
                           width,
                           height
                       ),
                       DELAY, 0,
                       SHADOW, false
                   );
               }
           }, <%# ccPublisherWeb.ApplicationVars.Current["ArticleList_PreviewImage_TooltipDelay"] %>);
       }

       function clearPrevImageTT() {
           if(prevImageTimer != null) { try { clearTimeout(prevImageTimer); } catch(e) {} }
           prevImageTimer = null;
           UnTip();
       }
      
       function artTT(artNum, text, showArticleNumber) {
           var ttTemplate = "<div class='AImagePopup'>";
           ttTemplate += "<div>";
           if (1 == showArticleNumber)
               ttTemplate += "<span class='PTitle'><%# ccPublisherWeb.TextDic.TxGet("Text_ArtikelNr") %>:</span>&nbsp;<span class='PValue'>" + artNum + "</span><br />";
           ttTemplate += "<span class='PTitle'><%# ccPublisherWeb.TextDic.TxGet("Text_Bezeichnung") %>:</span>&nbsp;<span class='PValue'>" + text + "</span>";
           ttTemplate += "</div>";
           ttTemplate += "</div>";

           Tip(ttTemplate, DELAY, 650, FOLLOWMOUSE, false, SHADOW, false);
       }
      
       function CADTT() {
           var ttTemplate = "<div class='AImagePopup'>";
           ttTemplate += "<div>";
           ttTemplate += "<span class='PTitle'><%# ccPublisherWeb.TextDic.TxGet("Text_ccRubrikCADVorschauAusgabe") %></span>";
           ttTemplate += "</div>";
           ttTemplate += "</div>";
      
           Tip(ttTemplate, DELAY, 650, FOLLOWMOUSE, false, SHADOW, false);
       }
      
       function redir(UrlOrForm) { setTimeout(function() {location.href = UrlOrForm;}, 0); }
          
       function js_AddToBOM(FormName, ArtNr)
       {
           FormName.stvBOMArtNr1.value = ArtNr;
           FormName.submit();
           FormName.stvBOMArtNr1.value = "";
       }
      
       function pageLock()
       { setTimeout(function() { <%# ModalProgressID %>.Show(); }, 500); }
      
       function createDialog(title, url, width, height) 
       {
           $(".ArticleDialog .SizeFrame")
               .css("width", width + "px")
               .css("height", height + "px");

           $(".ArticleDialog IFRAME")
               .attr("scrolling", "no")
               .attr("width", '100%')
               .attr("height", '100%')
               .attr("src", "about:blank");

           //we have to hide the iframe during dialog creation, to avoid to show old contents
           $(".ArticleDialog IFRAME").hide();

           articledetaildialog = $(".ArticleDialog").dialog({
               autoOpen: true,
               modal: true,
               closeOnEscape: true,
               title: title,
               width: width,
               height: height,
               resizable: JS_GLOBALS.jqDialogsResizable,
               draggable: true,
               open: function(event, ui) {
                   $(".ArticleDialog IFRAME").attr("src", url);
               },
               close: function(event, ui) {
                   viewerActive = false;
                   $(".ArticleDialog IFRAME").attr("src", url);
               }
           });   
       }
      
       function resizeDialog(width, height)
       {
           setTimeout(function() 
           {
               $(".ArticleDialog IFRAME").show();
               var frm = $(".ArticleDialog IFRAME").get(0);//here is your frame
               var doc = (frm.contentDocument ? frm.contentDocument : frm.contentWindow.document);//here is your document object
               var bdy = doc.body; //here is your body
               var dv = $("#ImageContainer", bdy);

               if(dv != undefined)
               {
                   var iframewidth, iframeheight;
                   var widthoffset = 0;
                   var heightoffset = 160;

                   if ((dv.width() + widthoffset) < width) { iframewidth = width; }
                   else { iframewidth = dv.width() + widthoffset; }

                   if ((dv.height() + heightoffset) < height) { iframeheight = height; }
                   else { iframeheight = dv.height() + heightoffset; }

                   $(".ArticleDialog").dialog('option', 'width', iframewidth);
                   $(".ArticleDialog").dialog('option', 'height', iframeheight);

                   articledetaildialog.data('width.dialog', iframewidth);
                   articledetaildialog.data('height.dialog', iframeheight);

                   $(".ArticleDialog .SizeFrame")
                       .css("width", '100%')
                       .css("height", '100%');
               }
           }, 1500);
       }
      
       function prepareViewer(title, url, width, height)
       {
           createDialog(title, url, width, height); resizeDialog(width, height);
       }
   </script>
</head>
<body>
   <ccPublisherWeb:JavascriptRessource ID="JavascriptRessource1" ScriptName="wz_tooltip.js" UseHandler="false" runat="server" />
    
   <form id="form1" runat="server">
      <asp:ScriptManager ID="ScriptManager1" runat="server" />

      <ccPublisherWeb:PageHeader ID="PageHeader1" CssClass="PageHeader" runat="server" />

      <asp:Panel ID="ExtendedSearchContainer" runat="server"></asp:Panel>

      <asp:PlaceHolder id="phAlternateText" runat="server" visible="false">
         <asp:Panel id="AlternateTextContainer" runat="server">
            <asp:Literal id="litAlternateText" runat="server"></asp:Literal>
         </asp:Panel>
      </asp:PlaceHolder>

      <div id="ModalBounds" class="ArtikelListe" runat="server">
         <div class="Header">
            <div class="HeaderLeft">
               <span><%# ccPublisherWeb.TextDic.TxGet("Text_Gefundene_Artikel") %> <asp:Label ID="lbAnzArtikelGefunden" CssClass="NumFound" runat="server" /></span>
            </div>
            
            <div class="HeaderRight">
               <asp:PlaceHolder ID="Placeholder_ViewSwitch" runat="server">
                  <table border="0" cellpadding="0" cellspacing="0">
                     <tr>
                        <td><%# ccPublisherWeb.TextDic.TxGet("Text_Ansicht_Waehlen") %></td>
                        <td><div class="ButtonSpacing"></div></td>
                        <td>
                           <asp:Panel ID="ButtonAnsichtTextOnly" runat="server" />
                        </td>
                        <td><div class="ButtonSpacing"></div></td>
                        <td>
                           <asp:Panel ID="ButtonAnsichtImagesAndText" runat="server" />
                        </td>
                        <td><div class="ButtonSpacing"></div></td>
                        <td>
                           <asp:Panel ID="ButtonAnsichtImages" runat="server" />
                        </td>
                     </tr>
                  </table>
               </asp:PlaceHolder>
            </div>
         </div>
         
         <div id="GridContent" class="GridContent" runat="server">
            <div class="GridContent_Inner">
               <asp:GridView
                  ID="GridArtikel"
                  AutoGenerateColumns="false"
                  AllowPaging="true"
                  GridLines="None"
                  AllowSorting="true"
                  PagerSettings-Visible="false"
                  CssClass="GridArtikel"
                  OnSorting="GridArtikelSorting"
                  OnRowCreated="GridArtikelRowCreated"
                  runat="server"
               >
                  <RowStyle CssClass="Grid_RowStyle" />
                  <AlternatingRowStyle CssClass="Grid_AltRowStyle" />
               </asp:GridView>
            
               <asp:PlaceHolder ID="Placeholder_ImageView" runat="server">
                  <div id="ArtikelImageView">
                     <table id="ArtikelImageView_Table" border="0" cellpadding="0" cellspacing="0">
                        <tr>
                           <asp:Repeater ID="Repeater_ImageView" runat="server">
                              <ItemTemplate>
                                 <td valign="top">
                                    <div class="ImageViewPanel">
                                       <div style="background-repeat: no-repeat; width: <%= ApplicationVars.Current["LargeArtikelPrevWidth"].ToString() %>px; height: <%# ApplicationVars.Current["LargeArtikelPrevHeight"].ToString() %>px;" class="IVP_Container">
                                          <%# Eval("TypID5") %>
                                       </div>
                                    
                                       <div class="CadLink"><%# Eval("CADLink") %></div>
                                    
                                       <div class="PArtNum">
                                          <span class="Title"><%# (ShowArticleNumber) ? TextDic.TxGet("Text_ArtikelNr") : "&nbsp;"%></span><br />
                                          <span class="ArtNum"><%# (ShowArticleNumber) ? Eval("ArtikelNr") : "&nbsp;"%></span>
                                       </div>
                                    
                                       <table class="PArtikelAttributes" border="0" cellpadding="0" cellspacing="0">
                                          <%# Eval("PArtikelAttributes") %>
                                       </table>
                                    </div>
                                 </td>
                                 <%# Eval("ImageView_PostHtml") %>
                              </ItemTemplate>
                           </asp:Repeater>
                        </tr>
                     </table>
                  </div>
               </asp:PlaceHolder>
            </div>
            
            <asp:Panel ID="pagerparams" runat="server" Visible="true"></asp:Panel>

            <div id="PagerDiv" runat="server">              
               <ccPublisherWeb:Pager
                  ID="GridArtikelPager"
                  GridControlID="GridArtikel"
                  OnPagerChange="GridArtikelPagerChange"
                  CssClass="ArtikelPager"
                  OnClientPageSwitch="pageLock()"
                  runat="server" />
            </div>
         </div>
      </div>

      <div style="display: none">
         <asp:HiddenField ID="hdGridMode" runat="server" />
         <asp:HiddenField ID="hdGridSortExpression" runat="server" />
         <asp:HiddenField ID="hdGridSortDirection" runat="server" />
         <asp:HiddenField ID="hdImpressionId" runat="server" />
         <asp:HiddenField ID="hdSearchTerm" runat="server" />
         
         <asp:TextBox ID="hdExtSearchLastFilter" ClientIDMode="Static" runat="server" EnableViewState="True"></asp:TextBox>
         <asp:TextBox ID="hdExtSearchProductTableFilter" ClientIDMode="Static" runat="server"></asp:TextBox>
         <asp:Button ID="hdPostBackExtSearch" ClientIDMode="Static" OnClick="SetProductTableFilter" runat="server" />

         <asp:Button ID="hdPostbackGridMode" OnClick="GridModeChanged" runat="server" />
      </div> 

      <div class="ArticleDialog" style="display: none; overflow: hidden;">
         <div class="SizeFrame" style="overflow:hidden;">
            <iframe src="#" scrolling="no" marginheight="0" marginwidth="0" border="0" frameborder="0"></iframe>
         </div>
      </div>
      
      <ccPublisherWeb:CadBoxDialogControl ID="CadBoxDialog" runat="server"/>

      <script language="javascript" type="text/javascript">
          <asp:PlaceHolder id="phEnableLoadArticleOnRowClick" runat="server">
            $(document).ready(function() {
                  $('#GridArtikel TR TD').not('.Item_LinkCadDaten').click(function(event){
                     var cadlink = $(this).parent().find('A.LinkCadDaten');
                     if(cadlink.length) { event.stopPropagation(); cadlink[0].click(); }
                  });

                  $('#GridArtikel TR TD').not('.Item_LinkCadDaten').css('cursor', 'pointer');
            });
         </asp:PlaceHolder>
            
          $(function() {
              <%-- Hide CAD Viewer in side panel --%>
              try {
                  if(parent && parent.Leer) { parent.Leer.PrevWinHidden(); }
              } catch(e) { }

              $(".LinkCadDaten").mouseover(function() {
                  CADTT();
              }).mouseout(function() {
                  UnTip();
              });

              <%# ccPublisherWeb.CustomApplicationHooks.Factory.ArticleList_PageLoadClientScript %>
          });
      </script>
   </form>
</body>
</html>
