﻿<%@ Page Language="C#" AutoEventWireup="true" Inherits="ccPublisherWeb.Bottom" Codebehind="Bottom.aspx.cs" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
   <title></title>

   <ccPublisherWeb:CustomerStyleSheet ID="StyleCadViewer" StyleSheetName="CADViewer.css" runat="server" />

   <style type="text/css">
      HTML, BODY, FORM
      {
         height: 100%;
         margin: 0;
         padding: 0;
      }
   </style>

   <!--[if IE 6]>
      <link rel="stylesheet" href="<%# ResolveUrl(ccPublisherWeb.CommonSettings.CustomerStyleFolder + "styleIE6.css") %>" type="text/css" media="screen" />
   <![endif]-->
</head>
<body id="Bottom" class="BottomPage">
   <form id="form1" runat="server">
      <asp:PlaceHolder ID="Placeholder_CadPreview" runat="server">
         <div id="CADViewer_Display" style="visibility: hidden">
            <div id="TopToolbar" class="CADViewerButtons">
               <div class="Left">
                  <div class="Right">
                     <div class="Center">
                        <input id="ckAutoPrev" onclick="toggleAutoPrevCadWindow()" type="checkbox" />
                        <a id="ckAutoPrevImg"></a>
                        <label for="ckAutoPrev"><%# ccPublisherWeb.TextDic.TxGet("Text_PreviewLegend") %></label>

                        <a id="CADViewerButton_DimDrawPDF" href="javascript:;" class="CADViewerButton_DimDrawPDF" onclick="startDimDrawPDF()" title="<%# TextDic.TxGet("Text_CadViewerDimDraw_ButtonPDFDirect_Tooltip") %>"><%# TextDic.TxGet("Text_CadViewerDimDraw_ButtonPDFDirect") %></a>
                     </div>
                  </div>
               </div>
               <div class="Lock"></div>
            </div>

            <div id="CADViewer">
               <div id="Toolbar" class="CADViewerButtons">
                  <div class="Header"></div>
                  <div class="Content">
                     <div class="ViewDirectionButtons">
                         <a class="CADViewerButton_Front" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_FRONT) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Front") %>"></a>
                         <a class="CADViewerButton_Right" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_RIGHT) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Right") %>"></a>
                         <a class="CADViewerButton_Top" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_TOP) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Top") %>"></a>
                         <a class="CADViewerButton_Back" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_BACK) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Back") %>"></a>
                         <a class="CADViewerButton_Left" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_LEFT) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Left") %>"></a>
                         <a class="CADViewerButton_Bottom" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_BOTTOM) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Bottom") %>"></a>
                         <a class="CADViewerButton_Iso" vmode="<%# Enum.GetName(typeof(CADClickDefines.ViewDirections), CADClickDefines.ViewDirections.VIEW_DIR_ISO) %>" title="<%# ccPublisherWeb.TextDic.TxGet("View_Isometric") %>"></a>
                     </div>
                     <div class="Spacer"></div>
                     <a class="CADViewerButton_2DViewer" onclick="start2DViewerCadWindow()" title="<%# TextDic.TxGet("Text_Ansicht2DVorschau") %>"></a>
                     <a class="CADViewerButton_3DViewer" onclick="start3DViewerCadWindow()" title="<%# TextDic.TxGet("Text_Ansicht3DVorschau") %>"></a>
                     <asp:PlaceHolder ID="PlaceHolder_ExportJumper" runat="server">
                         <a class="CADViewerButton_Export" onclick="openExportPanel()" title="<%# TextDic.TxGet("Text_ccRubrikCADVorschauAusgabe") %>"></a>
                     </asp:PlaceHolder>
                  </div>
                  <div class="Footer"></div>

                  <div class="Lock"></div>
               </div>
                     
               <asp:Image ID="Prev3DImg" CssClass="Prev3DImg" runat="server" />

               <div id="AutoPrevWarning" style="display: none">
                  <div id="AutoPrevInfoIcon"></div>
                  <p>&nbsp;</p>
                  <p><%# TextDic.TxGet("PreviewImage_Deactivated") %></p>
                  <p>&nbsp;</p>
                  <p><a onclick="toggleAutoPrevCadWindow(true)"><%# TextDic.TxGet("PreviewImage_ActivateQuestion") %></a></p>
              </div>
            </div>

            <div class="Lock"></div>
         </div>
      </asp:PlaceHolder>

      <div class="Container">
         <div class="SpacerLine">
            <div></div>
         </div>
         <div class="KiMText">
            <table border="0" cellpadding="0" cellspacing="0">
               <tr>
                  <td>
                     <a href="http://www.cadclick.com" target="_blank">
                        <span>Powered by CADClick<sup>&reg;</sup></span>
                     </a>
                  </td>
               </tr>
            </table>
         </div>
      </div>

      <script language="javascript" type="text/javascript">
         $(function() {
            $("#CADViewer #Toolbar A[vmode]").click(function(event) {
               parent.text.extChangeView($(this).attr("vmode"));
            });

            if($("#ckAutoPrevImg").is(":visible")) {
               $("#ckAutoPrevImg").click(function() {
                  var ckChecked = $("#ckAutoPrev").is(":checked");

                  $(this).toggleClass("checked", !ckChecked);

                  if(ckChecked) {
                     $("#ckAutoPrev").removeAttr("checked");
                  } else {
                     $("#ckAutoPrev").attr("checked", "checked");
                  }

                  toggleAutoPrevCadWindow();
               });

               $("LABEL[for=ckAutoPrev]").mouseover(function() {
                  $("#ckAutoPrevImg").addClass("hover");
               }).mouseout(function() {
                  $("#ckAutoPrevImg").removeClass("hover");
               });
            }
         });

         function swapImage(imgSRC, viewMode, autoPrev, is3D) {
            $("#<%# Prev3DImg.ClientID %>").attr("src", imgSRC);

            <%# CustomApplicationHooks.Factory.ClientOnCadViewerSidebarShown %>;

            $("#CADViewer_Display").css("visibility", "visible");

            if (is3D) {
                $(".CADViewerButton_3DViewer").show();
                if (autoPrev) {
                    $(".ViewDirectionButtons").show();
                }
                else {
                    $(".ViewDirectionButtons").hide();
                }
            }
            else {
                $(".CADViewerButton_3DViewer").hide();
                $(".ViewDirectionButtons").hide();
            }
            lockCadViewerToolbar(false);

            $("#CADViewer #Toolbar A[vmode]").toggleClass("Selected", false);
            $("#CADViewer #Toolbar A[vmode=" + viewMode + "]").toggleClass("Selected", true);

            if(autoPrev) {
               $("#ckAutoPrev").attr("checked", "checked");
               $("#ckAutoPrevImg").toggleClass("checked", true);
               $("#AutoPrevWarning").hide();
               $("#<%# Prev3DImg.ClientID %>").show();

               <%# CustomApplicationHooks.Factory.ClientOnCadViewerSidebarAutoPrev(true) %>;
            } else {
               $("#ckAutoPrev").removeAttr("checked");
               $("#ckAutoPrevImg").toggleClass("checked", false);
               $("#AutoPrevWarning").show();
               $("#<%# Prev3DImg.ClientID %>").hide();
                              
               <%# CustomApplicationHooks.Factory.ClientOnCadViewerSidebarAutoPrev(false) %>;
            }
         }


         function PrevWinHidden() {
            if($("#CADViewer").length) {
               <%# CustomApplicationHooks.Factory.ClientOnCadViewerSidebarHidden %>;

               $("#<%# Prev3DImg.ClientID %>").attr("src", "<%# ccPublisherWeb.CommonSettings.CustomerImagesFolder + "prev3d_blank.gif" %>");
               $("#CADViewer_Display").css("visibility", "hidden");
            }
         }


         function lockCadViewerToolbar(show) {
            var content = $("#CADViewer_Display");
            var contentLock = $("#CADViewer_Display > .Lock");

            if(show) {
               contentLock.width(content.innerWidth() + 2);
               contentLock.height(content.innerHeight() + 2);

               contentLock.show();
            } else {
               contentLock.hide();
            }
         }

         function toggleAutoPrevCadWindow(newState) {
            var state = false;
            
            if(arguments.length > 0) {
               state = newState;
            } else {
               state = $("#ckAutoPrev").is(":checked");
               if (state) {
                   $(".ViewDirectionButtons").css("display", "none");
               }
            }
            
            try {
               if(parent && parent.text) {
                  parent.text.extChangeAutoPrev(state);
               }
            } catch(e) { }
         }


         function start3DViewerCadWindow() {
            try {
               if(parent && parent.text) {
                  parent.text.start3DViewerExt();
               }
            } catch(e) { }
         }


         function start2DViewerCadWindow() {
            try {
               if(parent && parent.text) {
                  parent.text.start2DViewerExt();
               }
            } catch(e) { }
         }


         function startDimDrawPDF() {
            try {
               if(parent && parent.text) {
                  parent.text.startDimDrawPDFExt();
               }
            } catch(e) { }
         }

         function openExportPanel() {
            try {
               if(parent && parent.text) {
                  parent.text.ShowExportPanel();
               }
            } catch(e) { }
         }

         function showCADViewerButton_DimDrawPDF(show) {
            if($("#CADViewerButton_DimDrawPDF").length) {
               if(show) {
                  $("#CADViewerButton_DimDrawPDF").show();
               } else {
                  $("#CADViewerButton_DimDrawPDF").hide();
               }
            }
         }


         function CADPreview() {    
            if (document.CADPrevForm.AutoView.checked) {
               parent.text.document.mainForm.AutoPrevCallExt.value = "true";
               swap3DViews('ISO');
            } else {
               parent.text.document.mainForm.AutoPrevCallExt.value = "false";
            }
         }
      </script>
   </form>
</body>
</html>
