﻿<%@ Page Language="C#" ValidateRequest="false" AutoEventWireup="true" EnableViewStateMac="false" CodeBehind="Download.aspx.cs" Inherits="ccPublisherWeb.Download" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/PageHeader.ascx" TagName="PageHeader" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/DisclaimerDialog.ascx" TagName="DisclaimerDialog" TagPrefix="ccPublisherWeb" %>
<%@ Register Src="~/Controls/CadBoxDialogControl.ascx" TagName="CadBoxDialogControl" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml">
    <head runat="server">
        <title>CAD Download</title>
        <ccPublisherWeb:CustomerStyleSheet StyleSheetName="DownloadCenter.css" runat="server" />

        <asp:Placeholder ID="Placeholder_ModifyReferrer" runat="server">
            <script language="javascript" type="text/javascript" src="js-xsa-snippet.js"></script>
        </asp:Placeholder>
    </head>

    <body>
        <form id="form1" runat="server">
            <asp:ScriptManager ID="ScriptManager1" runat="server" AsyncPostBackTimeout="300" />
            <ccPublisherWeb:JavascriptRessource ScriptName="jquery.ui.tooltipext.js" UseHandler="true" runat="server" />
            <ccPublisherWeb:PageHeader ID="PageHeader1" CssClass="PageHeader" runat="server" />

            <div id="DownloadCenter"<%# ((CommonSettings.SessionSettings.CADBox.ToString()) == ccPublisherWeb.CadBoxModes.DownloadCenterExt.ToString()) ? " class=\"CadBox\"" : "" %>>
                <div class="OuterBorder">
                    <asp:PlaceHolder ID="Placeholder_ListEmpty" runat="server">
				        <p>&nbsp;</p>&nbsp;&nbsp;<%# ccPublisherWeb.TextDic.TxGet("Text_Leer") %><p>&nbsp;</p>
                    </asp:PlaceHolder>
            
                    <asp:PlaceHolder ID="Placeholder_GridView" runat="server">
                        <table id="DownloadTable" class="GridDownload" border="0" cellpadding="0" cellspacing="0" width="100%">
                            <thead>
                                <tr class="Grid_Header">
                                    <th class="Header_Index">&nbsp;</th>
                                    <th class="Header_Preview">&nbsp;</th>
                        
                                    <asp:PlaceHolder ID="Placeholder_HeaderCellArtikelNr" runat="server">
                                        <th class="Header_Produkt"><%# ccPublisherWeb.TextDic.TxGet("Text_ArtikelNr")  %></th>
                                    </asp:PlaceHolder>
                        
                                    <th class="Header_Beschreibung"><%# ccPublisherWeb.TextDic.TxGet("Text_Bezeichnung") %></th>
                                    <th class="Header_DetailImage">&nbsp;</th>
                                    <th class="Header_Filename"><%# ccPublisherWeb.TextDic.TxGet("Text_DateiDownload") %></th>
                                    <th class="Header_FileSize"><%# ccPublisherWeb.TextDic.TxGet("Text_Groesse") + "&nbsp;[KB]" %></th>
                                    <th class="Header_Buttons">&nbsp;</th>
                                </tr>
                            </thead>
                  
                            <tbody>
                                <asp:Repeater ID="RepeaterDownload" OnItemDataBound="ItemDataBound" runat="server">
                                    <ItemTemplate>
                                        <tr class="<%# Eval("RowCssClass") %>">
                                            <td class="Cell_Index"><%# Eval("Index") %></td>
                                            <td class="Cell_Preview">
                                                <asp:PlaceHolder ID="Placeholder_ItemPreview" runat="server">
                                                    <div style="<%# string.IsNullOrEmpty(Eval("ArtikelPreview_Small").ToString()) ? "" : ("background-image:url(" + Eval("ArtikelPreview_Small") + ");background-repeat: no-repeat") %>" imglarge="<%# string.IsNullOrEmpty(Eval("ArtikelPreview_Small").ToString()) ? "" : Eval("ArtikelPreview_Large") %>""></div>
                                                </asp:PlaceHolder>
                                            </td>
       
                                            <asp:PlaceHolder ID="Placeholder_ItemCellArtikelNr" runat="server">
                                                <td class="Cell_Produkt"><%# GetConfigLink(Convert.ToString(Eval("Produkt")), Convert.ToString(Eval("ConfigLink")))%></td>
                                            </asp:PlaceHolder>
                              
                                            <td class="Cell_Beschreibung"><%# Eval("Beschreibung") %></td>

                                            <td class="Cell_DetailImage">
                                                <div class="DetailImage" imglarge="<%# Eval("TooltipImageDetail") %>" style="display: <%# string.IsNullOrEmpty(Eval("TooltipImageDetail").ToString()) ? "none" : "" %>" />
                                            </td>

                                            <td class="Cell_Filename">
                                                <asp:PlaceHolder ID="Placeholder_FileLink" runat="server">
                                                    <a onclick="startDownload('BinaryFileRedirector.ashx?PATH=<%# ccPublisherWeb.UrlUtility.UrlEncode(Eval("Datei").ToString()) %>&MIME=application/octet-stream&WKID=<%# Eval("WarenkorbID") %>')" href="javascript:void(0);"><%# Eval("FileName") %></a>
                                                </asp:PlaceHolder>
                                 
                                                <asp:PlaceHolder ID="Placeholder_FileNotFound" runat="server">
                                                    <span class="FilenameSmall"><%# Eval("FileName") %></span><br /><span class="FileNotFound"><%# ccPublisherWeb.TextDic.TxGet("Text_DateiNichtGefunden") %></span>
                                                </asp:PlaceHolder>
                                            </td>
                              
                                            <td class="Cell_FileSize"><%# Eval("FileSizeKBString") %></td>
                              
                                            <td class="Cell_Buttons">
                                                <asp:PlaceHolder ID="Placeholder_SaveButton" runat="server">
                                                    <a class="ButtonSave" title="<%# ccPublisherWeb.TextDic.TxGet("Text_Download" ) %>" onclick="startDownload('BinaryFileRedirector.ashx?PATH=<%# ccPublisherWeb.UrlUtility.UrlEncode(Eval("Datei").ToString()) %>&MIME=application/octet-stream&WKID=<%# Eval("WarenkorbID") %>')" href="javascript:void(0);">
                                                        <img alt="Save" src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Download), "ccPublisherWeb.images.dummy.gif") %>" border="0" align="absmiddle" />
                                                    </a>
                                                </asp:PlaceHolder>

                                                <asp:PlaceHolder ID="Placeholder_ConfigButton" runat="server">
                                                    <a class="ButtonConfig" href="javascript:;" onclick="wkItemConfig('<%# Eval("ConfigLink") %>')" title="<%# ccPublisherWeb.TextDic.TxGet("Text_SpringeZurueck") %>">
                                                        <img alt="Config" src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Download), "ccPublisherWeb.images.dummy.gif") %>" border="0" align="absmiddle" />
                                                    </a>
                                                </asp:PlaceHolder>

                                                <asp:PlaceHolder ID="Placeholder_DeleteButton" runat="server">
                                                    <a class="ButtonDelete" href="javascript:;" onclick="wkItemDelete(<%# Eval("WarenkorbID") %>)" title="<%# ccPublisherWeb.TextDic.TxGet("Text_Delete") %>">
                                                        <img alt="Delete" src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Download), "ccPublisherWeb.images.dummy.gif") %>" border="0" align="absmiddle" />
                                                    </a>
                                                </asp:PlaceHolder>
                                            </td>
                                        </tr>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </tbody>
                  
                            <tfoot>
                                <tr class="AlleLoeschen">
                                    <td colspan="<%# (bool)ApplicationVars.Current["ArticleListShowArtikelNr"] ? "7" : "6" %>" align="right">
                                        <span><%# ccPublisherWeb.TextDic.TxGet("Text_AllDeleteTxt") %></span>
                                    </td>
                                    <td align="left">
                                        <a class="ButtonDeleteAll" href="javascript:;" onclick="delAll()" title="<%# ccPublisherWeb.TextDic.TxGet("Text_AllDeleteTxt") %>">
                                            <img src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Download), "ccPublisherWeb.images.dummy.gif") %>" border="0" align="absmiddle" />
                                        </a>
                                    </td>
                                </tr>
                     
                                <tr class="FooterSepLine">
                                    <td colspan="<%# (bool)ApplicationVars.Current["ArticleListShowArtikelNr"] ? "4" : "3" %>"></td>
                                    <td colspan="<%# (bool)ApplicationVars.Current["ArticleListShowArtikelNr"] ? "4" : "3" %>"><div></div></td>
                                </tr>
                     
                                <tr class="FileSizeTotal">
                                    <td colspan="<%# (bool)ApplicationVars.Current["ArticleListShowArtikelNr"] ? "7" : "6" %>" align="right">
                                        <span>Total&nbsp;<%# ccPublisherWeb.TextDic.TxGet("Text_unkomprimiert") %>:&nbsp;<%# SFileSizeOverall %></span>&nbsp;
                                    </td>
                                    <td>&nbsp;</td>
                                </tr>
                     
                                <tr class="ZipRow">
                                    <td colspan="<%# (bool)ApplicationVars.Current["ArticleListShowArtikelNr"] ? "7" : "6" %>" align="right">
                                        <span><%# ccPublisherWeb.TextDic.TxGet("Text_Zippen_aller") %></span>&nbsp;
                                    </td>
                                    <td align="left">
                                        <a href="javascript:;" onclick="startZipDownload()" class="ZipButton" title="<%# ccPublisherWeb.TextDic.TxGet("Text_Zippen_aller") %>">
                                            <img alt="ZIP button" src="<%# Page.ClientScript.GetWebResourceUrl(typeof(Download), "ccPublisherWeb.images.dummy.gif") %>" border="0" align="absmiddle" />
                                        </a>
                                    </td>
                                </tr>
                     
                                <asp:PlaceHolder ID="Placeholder_EmailForm" runat="server">
                                    <tr class="EmailRow">
                                        <td colspan="<%# (bool)ApplicationVars.Current["ArticleListShowArtikelNr"] ? "7" : "6" %>" align="right">
                                            <span><%# ccPublisherWeb.TextDic.TxGet("Text_SendToEmail") %></span>
                                            <ccPublisherWeb:TextBoxNoSubmit ID="txEmail" CssClass="EmailField" runat="server" />
                                            <input type="button" class="SendButton" onclick="sendEmail()" value="<%# ccPublisherWeb.TextDic.TxGet("Text_Senden") %>" />
                              
                                            <ajaxToolkit:TextBoxWatermarkExtender ID="TextBoxWatermarkExtender_txEmail" TargetControlID="txEmail" WatermarkCssClass="Watermark" runat="server" />
                                 
                                            <div id="EmailError" style="display:none"><%# ccPublisherWeb.TextDic.TxGet("Text_CustomerMailNoAlert") %></div>
                                        </td>
                                        <td>&nbsp;</td>
                                    </tr>
                                </asp:PlaceHolder>
                            </tfoot>
                        </table>

                        <asp:Literal ID="litCustomerContent" runat="server">
                        <%-- Used to display a custom footer.                                    --%>
                        <%-- To do this, override the method GetDownloadCenterAdditionalFooter() --%>
                        <%-- in class CustomApplicationHooks and return the desired HTML content --%>
                        </asp:Literal>

                        <asp:PlaceHolder ID="plh_DownloadInfo" runat="server">
                            <table id="BottomText" border="0" cellpadding="0" cellspacing="0">
                                <tr>
                                    <td valign="top"><img alt="Help" src="<%# ccPublisherWeb.CommonSettings.CustomerStyleFolder %>images/help.gif" align="absmiddle" border="0" /></td>
                                    <td>&nbsp;&nbsp;</td>
                                    <td valign="top"><%# ccPublisherWeb.TextDic.TxGet("Text_D_Area_Info1") %>&nbsp;<%# ccPublisherWeb.TextDic.TxGet("Text_D_Area_Info2") %></td>
                                </tr>
                            </table>
                        </asp:PlaceHolder> 
                    </asp:PlaceHolder>
                </div>
            </div>

            <div id="Dialog_ZipDownload" style="display: none"><iframe scrolling="no" width="400" height="115" frameborder="0"></iframe></div>

            <ccPublisherWeb:DisclaimerDialog ID="DisclaimerDialog" runat="server" />
            
            <ccPublisherWeb:CadBoxDialogControl ID="CadBoxDialog" runat="server"/>

            <div style="display: none">
                <asp:Button ID="btDummy_Dialog_ZipDownload" runat="server" />
                <asp:Button ID="btDelArticle" OnClick="DeleteArticle" runat="server" />
                <asp:Button ID="btDelAll" OnClick="DeleteAll" runat="server" />
                <asp:HiddenField ID="hdDelArticleID" runat="server" />
            </div>   
        </form>


        <script type="text/javascript">
            $(function() {
                <%# ccPublisherWeb.CustomApplicationHooks.Factory.DownloadCenter_PageLoadClientScript %>

                $("TD.Cell_Preview DIV[imglarge], TD.Cell_DetailImage DIV[imglarge]").tooltipext({
                    helperClasses: "ArtTT",
                    followMouse: true,
                    beforeShow : function(event, ui) {
                        var sizeHelper = $("<div>", { "style" : "width:0;height:0;overflow:hidden" }).appendTo($("BODY"));
                        $("<img>").appendTo(sizeHelper).load(function() {
                            ui.helper.css("background-image", "url(" + $(this).attr("src")  + ")");
                            ui.helper.width($(this).width()).height($(this).height());
                            $(this).parent().remove();
                        }).attr("src", $(this).attr("imglarge"));

                        return false;
                    }
                });
            });

            function showModalProgressDelayed() { setTimeout(function() {<%# ModalProgressID %>.Show();}, 500); }
   
            function delAll() {
                <%# MessageBoxID %>.Show({
                    title      : "<%# ccPublisherWeb.TextDic.TxGet("Text_Download") %>",
                    messageText: "<%# DBFuncs.FormatQuotedValueForJS(ccPublisherWeb.TextDic.TxGet("Text_Downloadcenter_AllDeleteTxt")) %>",
                    width: 400,
                    height: 110,
                    focusButton: MessageBox.Constants.MB_NO,
                    icon: MessageBox.Constants.MB_ICON_QUESTION,
                    buttons: MessageBox.Constants.MB_YES | MessageBox.Constants.MB_NO,
                    onYes: function(sender) { sender.Close(); showModalProgressDelayed(); <%# Page.ClientScript.GetPostBackEventReference(btDelAll, "") %>; }
                });
            }
      
            function wkItemDelete(wkId) {
                showModalProgressDelayed();
                $("#hdDelArticleID").val(wkId);
                <%# Page.ClientScript.GetPostBackEventReference(btDelArticle, "") %>;
            }

            function wkItemConfig(configLink) {
                showModalProgressDelayed();
                ccPublisherWeb.SafeRedirect(configLink, parent.text);
            }
      
            function startDownload(target) {
                <%-- ReSharper disable UseOfImplicitGlobalInFunctionScope --%>
                
                var showdisclaimerdialog = '<%# ShowDisclaimerDialog.ToString() %>' == 'True' ? true : false;

                if (showdisclaimerdialog) {
                    showDisclaimerDialog(target);
                } else {
                    window.location.assign(target);
                }
                
                <%-- ReSharper restore UseOfImplicitGlobalInFunctionScope --%>
            }

            function startZipDownload(email) {
                $("#Dialog_ZipDownload").dialog({
                    autoOpen: true,
                    modal: true,
                    closeOnEscape: true,
                    title: email ? "<%# ccPublisherWeb.TextDic.TxGet("Text_ZipDialogEmail") %>" : "<%# ccPublisherWeb.TextDic.TxGet("Text_ZipDialog") %>",
                    width: 404,
                    height: 150,
                    resizable: JS_GLOBALS.jqDialogsResizable,
                    draggable: JS_GLOBALS.jqDialogsDraggable,
                    close: function() { $("#Dialog_ZipDownload IFRAME").attr("src", ""); }
                });
         
                var extsessionid = '<%# CommonSettings.SessionSettings.ExtSessionID %>';
                var dlSrc = 'DownloadZipInit.aspx';
                dlSrc += extsessionid == ''? '' : '?extsessionid=' + extsessionid;
         
                if(email)
                {
                    dlSrc += dlSrc.indexOf('?') > -1 ? '&MAILTO=' : '?MAILTO=';
                    dlSrc += ccPublisherWeb.URLEncode(email);
                }
         
                $("#Dialog_ZipDownload IFRAME").attr("src", dlSrc);
            }
      
            function abortZip() {
                $("#Dialog_ZipDownload").dialog("close");
                $("#Dialog_ZipDownload IFRAME").attr("src", "");
            }

            var errorTipWidth  = 0;
            var errorTipHeight = 0;
            var errorShowDelayTimer = null;
      
            function sendEmail() {
                var inputField  = document.getElementById('<%# txEmail.ClientID %>');
                var mailAddress = inputField.value;

                if(!ccPublisherWeb.CheckEmail(mailAddress)) {
                if(!$("#EmailError").is(":visible")) { $("#EmailError").fadeIn(); }
                inputField.focus();
                } else {
                $("#EmailError").hide();
                inputField.value = "";
                $find('<%# TextBoxWatermarkExtender_txEmail.ClientID %>').set_Text('');
                startZipDownload(mailAddress);
                }
            }

            <asp:PlaceHolder ID="Placeholder_ReloadDownloadAndSearch" Visible="false" runat="server">
                try {
                    if(parent && parent.Oben) { parent.Oben.location.href = parent.Oben.location.href; }
                } catch(e) { }

                try {
                    if(parent && parent.title) { parent.title.location.href = parent.title.location.href; }
                } catch(e) { }
            </asp:PlaceHolder>
        </script>
    </body>
</html>
