﻿<%@ Page Language="C#" AutoEventWireup="true" CodeBehind="RequestPassword.aspx.cs" Inherits="ccPublisherWeb.RequestPassword" %>

<%@ Register Assembly="ccPublisherWeb" Namespace="ccPublisherWeb" TagPrefix="ccPublisherWeb" %>

<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">

<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
   <title>Request Password</title>
   
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="RegisterLogin.css" runat="server" />
   <ccPublisherWeb:CustomerStyleSheet StyleSheetName="ErrorPanel.css" runat="server" />
</head>
<body>
   <script language="javascript" type="text/javascript" src="ccHandlerResource.ashx?RES_URL=ccPublisherWeb.JS.wz_tooltip.js"></script>
   
   <form id="form1" runat="server">
      <asp:ScriptManager ID="ScriptManager1" EnablePageMethods="true" runat="server" />
      
      <asp:PlaceHolder ID="Placeholder_Main" runat="server">
         <div id="RequestPasswordPage">
            <div class="DCenter">
               <asp:PlaceHolder ID="Placeholder_Form" runat="server">
                  <div class="Paragraph Center">
                     <%# ccPublisherWeb.TextDic.TxGet("Text_EmailRequestTitle") %>
                  </div>
            
                  <div id="PasswordBox">
                     <h1><%# ccPublisherWeb.TextDic.TxGet("Text_PasswortAnfordern") %></h1>
                  
                     <div id="InnerBorder">
                        <table id="PasswordTable" border="0" cellpadding="2" cellspacing="1">
                           <tbody>
                              <tr>
                                 <td class="Title"><%# ccPublisherWeb.TextDic.TxGet("Text_CustomerEMail") %></td>
                                 <td class="Value">
                                    <asp:TextBox ID="txEmail" runat="server" />
                                 </td>
                              </tr>
                           </tbody>
                        </table>

                        <div id="Buttons">
                           <input id="btSubmit" type="button" value="<%# ccPublisherWeb.TextDic.TxGet("Text_btnAnfordern") %>" onclick="requestPassword()" />
                        </div>
                     </div>
                  
                     <div style="display: none">
                        <asp:Button ID="btSubmit" OnClick="Submit" runat="server" />
                     </div>
                  </div>
               </asp:PlaceHolder>
            
               <asp:PlaceHolder ID="Placeholder_Success" runat="server">
                  <div class="Paragraph Center">
                     <%# ccPublisherWeb.TextDic.TxGet("Text_EmailRequestText")%>
                  </div>
                  <div class="Paragraph Center">
                     <%# ccPublisherWeb.TextDic.TxGet("Text_Ihr_Team")%>
                  </div>
               </asp:PlaceHolder>

               <div class="Paragraph">&nbsp;</div>
            
               <div id="Footer">
                  <%# ccPublisherWeb.TextDic.TxGet("Text_Copy_Rechte") %>
               </div>
            </div>
         </div>
      </asp:PlaceHolder>

      <asp:PlaceHolder ID="Placeholder_Error" Visible="false" runat="server">
         <div id="ErrorDiv">
            <ccPublisherWeb:ErrorPanel ID="ErrorPanel" CssClass="ErrorPanel" runat="server" />
         </div>
      </asp:PlaceHolder>

      
      <asp:Placeholder ID="Placeholder_HeaderScript" runat="server">
         <script language="javascript" type="text/javascript">
            function requestPassword() {
               enableForm(false);

               if(formValidator.Validate()) {
                  var email = String.trim($("#<%# txEmail.ClientID %>").val());

                  $.ajax({
                     type: "GET",
                     url: "<%# ResolveUrl("~/RegForm.aspx") %>?checkEmailExists=" + email,
                     cache: false,
                     contentType: 'application/json; charset=utf-8',
                     success: function(msg) {
                        enableForm(true);

                       /* if(msg.haserror == 1) {
                           showError("<%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_ErrorEmailCheck_Title") %>", "Error: " + msg.errormessage);
                        } else {*/
                           if(parseInt(msg) > 0) {
                              setTimeout(function() {
                                 <%# ModalProgressID %>.Show();
                                 <%# Page.ClientScript.GetPostBackEventReference(btSubmit, "") %>;
                              }, 0);
                           } else {
                              FieldValidator.ShowError(
                                 $("#<%# txEmail.ClientID %>"),
                                 "<%# ccPublisherWeb.TextDic.TxGet("Text_EmailRequestEmailNotAvailable") %>");
                              
                              $("#<%# txEmail.ClientID %>").focus();
                           }
                        
                     },
                     error: function (xhr, ajaxOptions, thrownError) {
                        enableForm(true);
                        showError("<%# ccPublisherWeb.TextDic.TxGet("Text_RegForm_ErrorEmailCheck_Title") %>", "Error " + xhr.status + ": " + thrownError);
                     }   
                  });
               } else {
                  enableForm(true);
               }
            }


            function showError(titleText, errorText) {
               <%# MessageBoxID %>.Show({
                  title: titleText,
                  messageText: errorText,
                  width: 400,
                  height: 110,
                  icon: MessageBox.Constants.MB_ICON_ERROR,
                  buttons: MessageBox.Constants.MB_OK
               });
            }
         </script>
      </asp:Placeholder>
      
      <asp:PlaceHolder ID="Placeholder_ValidatorScript" runat="server">
         <script language="javascript" type="text/javascript">
            $(function() {
               formValidator = new FieldValidator();
               formValidator.SetOnOkFunction(function() { requestPassword(); });

               formValidator.Add(new ValidationEvent(
                  $("#<%# txEmail.ClientID %>"),
                  function(sender) {
                     return ccPublisherWeb.CheckEmail(sender.val());
                  }
               ));
            });


            function enableForm(enable) {
               if(enable) {
                  $("#<%# txEmail.ClientID %>").removeAttr("disabled");
                  $("#<%# txEmail.ClientID %>").toggleClass("Spinner", false);
                  $("#btSubmit").removeAttr("disabled");
               } else {
                  $("#<%# txEmail.ClientID %>").attr("disabled", "disabled");
                  $("#<%# txEmail.ClientID %>").toggleClass("Spinner", true);
                  $("#btSubmit").attr("disabled", "disabled");
               }
            }
         </script>
      </asp:PlaceHolder>
   </form>
</body>
</html>
